/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.entity;

import net.jayjay.dangerzone.entity.EntityLiving;
import net.jayjay.dangerzone.entity.model.ModelButterfly;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.World;
import org.lwjgl.opengl.GL11;

public class EntityButterfly
extends EntityLiving {
    public float rot;
    public float timeOffs;
    public float speed;
    public float rotA = (float)(Math.random() + 1.0) * 0.003f;
    private static ModelButterfly butterflyModel = new ModelButterfly();
    private int upwardGlideTicks = 0;

    public EntityButterfly(World world) {
        super(world);
    }

    public EntityButterfly(World level, float x, float y, float z) {
        super(level);
        this.texture = "/butterfly.png";
        this.setSize(0.4f, 0.4f);
        this.setHealth(5);
        this.setPos(x, y, z);
        this.timeOffs = (float)Math.random() * 1239813.0f;
        this.rot = (float)(Math.random() * Math.PI * 2.0);
        this.speed = 0.5f;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.health < 0) {
            this.health = 0;
        }
        if (this.isDead()) {
            this.remove();
        }
        if (this.y < -100.0f) {
            this.remove();
        }
        float xa = 0.0f;
        float ya = 0.0f;
        this.rot += this.rotA;
        this.rotA = (float)((double)this.rotA * 0.99);
        this.rotA = (float)((double)this.rotA + (Math.random() - Math.random()) * Math.random() * (double)0.02f);
        xa = (float)Math.sin(this.rot) * 0.3f;
        ya = (float)Math.cos(this.rot) * 0.3f;
        float xaOrg = xa;
        float zaOrg = ya;
        double time = (double)System.nanoTime() / 1.0E9 * 2.0 + (double)this.timeOffs;
        this.yd = (float)(Math.sin(time) * (double)0.05f);
        if (this.onGround) {
            this.upwardGlideTicks = 20;
        }
        if (this.upwardGlideTicks > 0) {
            this.yd = 0.1f;
            --this.upwardGlideTicks;
        }
        this.moveRelative(xa, ya, 0.01f);
        this.yd = (float)((double)this.yd - 0.01);
        this.move(this.xd, this.yd, this.zd);
        if (xaOrg != xa || zaOrg != ya) {
            this.rot += (float)Math.PI;
            xa = (float)Math.sin(this.rot) * 0.3f;
            ya = (float)Math.cos(this.rot) * 0.3f;
            this.xd = xa;
            this.zd = ya;
        }
        this.xd *= 0.98f;
        this.yd *= 0.98f;
        this.zd *= 0.98f;
        if (this.onGround) {
            this.xd *= 0.9f;
            this.zd *= 0.9f;
        }
    }

    @Override
    public void render(float a2) {
        GL11.glEnable(3553);
        Textures.bindNearest(this.texture);
        GL11.glPushMatrix();
        double time = (double)System.nanoTime() / 1.0E9 * 20.0 * (double)this.speed + (double)this.timeOffs;
        float size = 0.029166667f;
        float yy = (float)(-Math.abs(Math.sin(time * 0.6662)) * 2.0 - 10.0);
        GL11.glTranslatef(this.xo + (this.x - this.xo) * a2, this.yo + (this.y - this.yo) * a2, this.zo + (this.z - this.zo) * a2);
        GL11.glScalef(1.0f, -1.0f, 1.0f);
        GL11.glScalef(size, size, size);
        GL11.glTranslatef(0.0f, yy, 0.0f);
        float c2 = 57.29578f;
        GL11.glRotatef(this.rot * c2 + 180.0f, 0.0f, 1.0f, 0.0f);
        butterflyModel.render((float)time);
        GL11.glPopMatrix();
        GL11.glDisable(3553);
    }
}

